---
generated_at: 2026-01-21 16:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-Unit Test Generation

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00002.sql` (行1-250)
- E-02: `src/plsql/pkg/qa_unit_tests_pkg.sql` (行1-1556)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (行4)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行6-7)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Page IDは2である | E-01（行15: p_id=>2） | ○ |
| C-02 | エイリアスはUNIT-TEST-GENERATIONである | E-01（行17: p_alias=>'UNIT-TEST-GENERATION'） | ○ |
| C-03 | Protection LevelはCである | E-01（行22: p_protection_level=>'C'） | ○ |
| C-04 | モーダルダイアログである | E-01（行18: p_page_mode=>'MODAL'） | ○ |
| C-05 | P2_SCHEME_NAMESはシャトル形式である | E-01（行173: p_display_as=>'NATIVE_SHUTTLE'） | ○ |
| C-06 | P2_OPTIONはラジオグループである | E-01（行188: p_display_as=>'NATIVE_RADIOGROUP'） | ○ |
| C-07 | P2_OPTIONのデフォルト値は1である | E-01（行187: p_item_default=>'1'） | ○ |
| C-08 | CREATEボタンはP2_OPTION IS NOT NULLの条件を持つ | E-01（行127: p_button_condition=>'P2_OPTION'） | ○ |
| C-09 | DELETEボタンには確認ダイアログがある | E-01（行144: p_confirm_message=>'Do you really want to delete...'） | ○ |
| C-10 | 生成プロセスはqa_unit_tests_pkg.p_create_unit_tests_for_schemesを呼び出す | E-01（行218: process_sql_clob） | ○ |
| C-11 | 削除プロセスはqa_unit_tests_pkg.p_delete_unit_tests_for_schemesを呼び出す | E-01（行232: process_sql_clob） | ○ |
| C-12 | 成功メッセージは「Unit Test Packages created.」 | E-01（行223: p_process_success_message） | ○ |
| C-13 | 削除成功メッセージは「Unit Test Packages deleted.」 | E-01（行237: p_process_success_message） | ○ |
| C-14 | p_create_unit_tests_for_schemesはpi_optionとpi_scheme_namesを受け取る | E-02（行1488-1521） | ○ |
| C-15 | p_delete_unit_tests_for_schemesはpi_scheme_namesを受け取る | E-02（行1523-1552） | ○ |
| C-16 | オプション1はgc_utplsql_single_packageに対応 | E-02（行687, 312-313: gc_utplsql_single_package） | ○ |
| C-17 | オプション2はgc_utplsql_single_package_per_ruleに対応 | E-02（行754, 313-314: gc_utplsql_single_package_per_rule） | ○ |
| C-18 | ルールが未定義の場合はエラーになる | E-02（行346-370: p_verify_rules） | ○ |
| C-19 | 無効なスキーム名の場合はエラーになる | E-02（行326-331: p_validate_input） | ○ |
| C-20 | 無効なオプション値の場合はエラーになる | E-02（行312-316: p_validate_input） | ○ |
| C-21 | パッケージ名プレフィックスはgc_utplsql_ut_test_packages_prefixで定義 | E-02（行699, 775） | ○ |
| C-22 | シャトルの区切り文字はコロン | E-02（行1508-1509, 1540-1541: pi_separator => ':'） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、ソースコードと完全に整合している

## 6) レビュアーチェックリスト（最小）
- [ ] QA_SCHEME_NAMES_FOR_TESTING_Vビューが正しく定義されているか確認
- [ ] utPLSQLフレームワークがデータベースにインストールされているか確認
- [ ] 生成されるパッケージ名がOracle命名規則（30文字制限等）に違反しないか確認
- [ ] DDL権限（CREATE PACKAGE）がユーザーに付与されているか確認
- [ ] 大量のルールがある場合のパフォーマンスを確認
